const Gallery = require("../models/Gallery");


const uploadImage = async (req, res) => {
    try {
        if(!req.body.images || !Array.isArray(req.body.images) || req.body.images.length === 0) {
            return res.status(400).json({ success: false, message: "No images uploaded" });
        }

        const galleryData = req.body.images.map((image) => ({
            name: req.body.name,
            image: image
        }));

        await Gallery.insertMany(galleryData);

        return res.status(200).json({ 
            success: true, 
            message: "Galleries uploaded and saved successfully",
        });
    } catch (error) {
        console.error("Error in uploadImage:", error.message);

        if (error.name === 'ValidationError') {
            return res.status(400).json({ success: false, message: "Invalid data provided" });
        }

        return res.status(500).json({ success: false, message: "An error occurred" });
    }
};

const deleteImage = async (req, res) => {
    try {
        const { name } = req.params;

        if (!name) {
            return res.status(400).json({ success: false, message: "Image name is required" });
        }

        await Gallery.deleteMany({ name });

        return res.status(200).json({ 
            success: true, 
            message: "Galleries deleted successfully",
        });
    } catch (error) {
        console.error("Error in deleteImage:", error.message);

        if (error.name === 'ValidationError') {
            return res.status(400).json({ success: false, message: "Invalid data provided" });
        }

        return res.status(500).json({ success: false, message: "An error occurred" });
    }
}

module.exports = {
    uploadImage,
    deleteImage
}