const express = require('express');
const multer = require('multer');

const { uploadImage, deleteImage } = require('../controllers/upload_controller');
const { cloudflareDelete, cloudflareUpload } = require('../middleware/cloudflare');
const { authorized } = require('../middleware/authorized');

const router = express.Router();
const upload = multer({ storage: multer.memoryStorage() });

router.post('/gallery', authorized, upload.array('gallery'), cloudflareUpload, uploadImage);

router.delete('/gallery/:name', authorized, cloudflareDelete, deleteImage);

module.exports = router;