const mongoose = require('mongoose');
require('dotenv').config();


const connectDB = async () => {
	try {
        const conn = await mongoose.connect(process.env.ATLAS_URI);
		console.log(`MongoDB Connected: ${conn.connection.host}`);
	} catch (error) {
		console.error(`Error: ${error.message}`);
		process.exit(1);
	}
};

module.exports = connectDB;
