const Gallery = require("../models/Gallery");

const getGallery = async (req, res) => {
    try {
        const galleries = await Gallery.find({});

        if (!galleries.length) {
            return res.status(404).json({ success: false, message: "No galleries found" });
        }

        const uniqueGalleries = [...new Set(galleries.map(gallery => gallery.name))].map(name => ({ name }));

        return res.status(200).json({ success: true, data: uniqueGalleries });
    } catch (error) {
        console.error("Error in getGallery:", error.message);
        return res.status(500).json({ success: false, message: "An error occurred" });
    }
};


const singleGallery = async (req, res) => {
    try {
        const { name } = req.params;

        if(!name){
            return res.status(400).json({ success: false, message: "Parameters required" });
        }

        const galleries = await Gallery.find({ name: name});

        if (!galleries.length) {
            return res.status(404).json({ success: false, message: "No galleries found" });
        }

        const images = galleries.map(gallery => `https://imagedelivery.net/wO6ihUlg1M7aee1mES2PLg/${gallery.image}/public`);

        return res.status(200).json({ success: true, data: images });
    } catch (error) {
        console.error("Error in singleGallery:", error.message);
        return res.status(500).json({ success: false, message: "An error occurred" });
    }
}

module.exports = {
    getGallery,
    singleGallery
}