require("dotenv").config();

const authorized = async (req, res, next) => {
    const authHeader = req.header("Authorization");

    if (!authHeader || !authHeader.startsWith("Bearer ")) {
        return res.status(403).json({ 
            success: false, 
            message: "Unauthorized: Missing or invalid Authorization header" 
        });
    }

    const bearerToken = authHeader.split(" ")[1].trim();
    const validToken = process.env.AUTH_TOKEN;

    if (!validToken || bearerToken !== validToken) {
        return res.status(403).json({ 
            success: false, 
            message: "Forbidden: Invalid credentials" 
        });
    }

    next();
};

module.exports = { authorized };